/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.indication.client;

import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.indication.client.HSCCltAuthenticator;
import com.ibm.hsc.indication.client.HSCCltConnMonitor;
import com.ibm.hsc.indication.client.HSCCltEventQueue;
import com.ibm.hsc.indication.client.HSCCltSubscription;
import com.ibm.hsc.indication.client.HSCConnErrHandler;
import com.ibm.hsc.indication.client.HSCEvent;
import com.ibm.hsc.indication.client.HSCEventHandler;
import com.ibm.hsc.indication.client.HSCHandlerSubscription;
import com.ibm.hsc.indication.client.HSCIndicationErrLogger;
import com.ibm.hsc.indication.client.HSCQueueSubscription;
import com.ibm.hsc.indication.client.HSCSSLSocketCreator;
import com.ibm.hsc.indication.client.HSCSocket;
import com.ibm.hsc.indication.client.HSCSubscriptionMgr;
import com.ibm.hsc.indication.client.redhat.HscRHSocket;
import com.ibm.hsc.rep.client.CIMClassCache;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HSCSubscriptionMgrImpl
extends Thread
implements HSCSubscriptionMgr {
    private static final String COMMON_BUNDLE_NAME = "HSCCommonBundle";
    private static final String ERROR_INVALID_SUB_ID = "HMCERRV3EVT000: Invalid subscription id {0}";
    private static final String ERROR_AUTHENTICATE = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "ERROR_AUTHENTICATE", "HMCERRV3EVT001: Authentication failed");
    private HSCCltAuthenticator mAuthenticator = null;
    private HSCSocket mSocket;
    private boolean mAutoClose;
    private String mHostName;
    private int mPort = 9197;
    private int mRetry;
    private HSCConnErrHandler mConnErrHandler;
    private Hashtable mEvents;
    private Hashtable mSubscriptions;
    private boolean mClosed;
    private static int mNextId = 0;
    private String mLocalHostName = null;
    private boolean mReconnAfterFail = true;
    private HSCCltConnMonitor mConnMonitor = null;
    private String mNameSpace = null;
    private boolean mInReading = false;
    private boolean mInReconnect = false;
    private long mLastCommTime = 0L;
    private static String mLogFileName = null;
    private static PrintStream mLogPrintStream = null;
    public static final int LOST_CONN_EVENT = -1;
    public static final int RECONNECT_EVENT = -2;
    public static final int DUMMY_CONN_EVENT = -3;
    public HSCIndicationErrLogger mErrLogger = null;

    static void println(String string) {
        if (mLogPrintStream != null) {
            mLogPrintStream.println("" + new Date(System.currentTimeMillis()) + " " + Thread.currentThread().getName() + " " + string);
            mLogPrintStream.flush();
        }
    }

    public String getServerHostName() {
        return this.mHostName;
    }

    public int getServerPort() {
        return this.mPort;
    }

    public int getConnectionRetryTime() {
        return this.mRetry;
    }

    public void setConnectionRetryTime(int n) {
        this.mRetry = n;
    }

    public HSCConnErrHandler getConnErrHandler() {
        return this.mConnErrHandler;
    }

    public void setConnErrHandler(HSCConnErrHandler hSCConnErrHandler) {
        this.mConnErrHandler = hSCConnErrHandler;
    }

    public boolean isAutoClose() {
        return this.mAutoClose;
    }

    public long getLastCommTime() {
        return this.mLastCommTime;
    }

    public boolean isInReading() {
        return this.mInReading;
    }

    public void setAutoClose(boolean bl) {
        this.mAutoClose = bl;
    }

    public boolean isClosed() {
        return this.mClosed;
    }

    public int getSubscriptionNum() {
        return this.mSubscriptions.size();
    }

    private static synchronized int getNextId() {
        return mNextId++;
    }

    public HSCSubscriptionMgrImpl(String string, String string2, int n, boolean bl, int n2, HSCConnErrHandler hSCConnErrHandler, HSCIndicationErrLogger hSCIndicationErrLogger) {
        HSCSubscriptionMgrImpl.println("Create HSCSubscriptionMgrImpl hostName " + string + " nameSpace " + string2 + " port " + n + " aClose " + bl + " retry " + n2);
        HSCSubscriptionMgrImpl.println("errHandler " + hSCConnErrHandler + " logger " + hSCIndicationErrLogger);
        this.mNameSpace = string2;
        this.mHostName = string;
        this.mErrLogger = hSCIndicationErrLogger;
        if (n != -1) {
            this.mPort = n;
        }
        this.mAutoClose = bl;
        this.mRetry = n2;
        this.mConnErrHandler = hSCConnErrHandler;
        this.mEvents = new Hashtable();
        this.mSubscriptions = new Hashtable();
        HSCSubscriptionMgrImpl.println(" ceating ClientAuthenticator");
        this.mAuthenticator = this.getClientAuthenticator();
        HSCSubscriptionMgrImpl.println(" connecting");
        this.connect();
        HSCSubscriptionMgrImpl.println(" set sub mgr info to ClientAuthenticator");
        this.mAuthenticator.setSubscriptionMgrInfo(string, string2, this.getClientInfo(), hSCIndicationErrLogger, this.mLocalHostName);
    }

    public HSCSubscriptionMgrImpl(String string, String string2, int n, boolean bl, int n2, HSCConnErrHandler hSCConnErrHandler, HSCIndicationErrLogger hSCIndicationErrLogger, String string3, boolean bl2) {
        HSCSubscriptionMgrImpl.println("Create HSCSubscriptionMgrImpl hostName " + string + " nameSpace " + string2 + " port " + n + " aClose " + bl + " retry " + n2);
        HSCSubscriptionMgrImpl.println("localHostName " + string3 + " reconnAftFail " + bl2);
        HSCSubscriptionMgrImpl.println("errHandler " + hSCConnErrHandler + " logger " + hSCIndicationErrLogger);
        this.mNameSpace = string2;
        this.mHostName = string;
        this.mErrLogger = hSCIndicationErrLogger;
        if (n != -1) {
            this.mPort = n;
        }
        this.mAutoClose = bl;
        this.mLocalHostName = string3;
        this.mReconnAfterFail = bl2;
        this.mRetry = n2;
        this.mConnErrHandler = hSCConnErrHandler;
        this.mEvents = new Hashtable();
        this.mSubscriptions = new Hashtable();
        HSCSubscriptionMgrImpl.println(" ceating ClientAuthenticator");
        this.mAuthenticator = this.getClientAuthenticator();
        HSCSubscriptionMgrImpl.println(" connecting");
        this.connect();
        HSCSubscriptionMgrImpl.println(" set sub mgr info to ClientAuthenticator");
        this.mAuthenticator.setSubscriptionMgrInfo(string, string2, this.getClientInfo(), hSCIndicationErrLogger, this.mLocalHostName);
    }

    private String getClientInfo() {
        Exception exception = new Exception();
        String string = HSCSubscriptionMgrImpl.getStackTrace(exception);
        HSCSubscriptionMgrImpl.println("clientInfo " + HSCSubscriptionMgrImpl.getStackTrace(exception));
        return string;
    }

    static String getStackTrace(Throwable throwable) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            throwable.printStackTrace(printStream);
            String string = byteArrayOutputStream.toString();
            printStream.close();
            byteArrayOutputStream.close();
            return string;
        }
        catch (Throwable throwable2) {
            if (mLogPrintStream != null) {
                throwable2.printStackTrace(mLogPrintStream);
            }
            return null;
        }
    }

    private HSCSSLSocketCreator getSSLSockCreator() {
        try {
            Class<?> clazz = Class.forName("com.ibm.hsc.indication.client.HSCSSLSocketCreatorImpl");
            HSCSSLSocketCreator hSCSSLSocketCreator = (HSCSSLSocketCreator)clazz.newInstance();
            return hSCSSLSocketCreator;
        }
        catch (Throwable throwable) {
            HSCSubscriptionMgrImpl.println(HSCSubscriptionMgrImpl.getStackTrace(throwable));
            this.logException(throwable);
            return null;
        }
    }

    private HSCCltAuthenticator getClientAuthenticator() {
        try {
            Class<?> clazz = Class.forName("com.ibm.hsc.indication.client.HSCCltAuthenticatorImpl");
            HSCCltAuthenticator hSCCltAuthenticator = (HSCCltAuthenticator)clazz.newInstance();
            return hSCCltAuthenticator;
        }
        catch (Throwable throwable) {
            HSCSubscriptionMgrImpl.println(HSCSubscriptionMgrImpl.getStackTrace(throwable));
            this.logException(throwable);
            return null;
        }
    }

    private void connect() {
        this.mSocket = null;
        long l = System.currentTimeMillis() + (long)(this.mRetry * 1000);
        Socket socket = null;
        Object var4_3 = null;
        while (this.mRetry == -1 || System.currentTimeMillis() <= l) {
            try {
                HSCSSLSocketCreator hSCSSLSocketCreator = this.getSSLSockCreator();
                HSCSubscriptionMgrImpl.println("creating socket");
                socket = hSCSSLSocketCreator.createSSLSocket(this.mHostName, this.mPort);
                if (socket == null) {
                    HSCSubscriptionMgrImpl.println("creating plain socket");
                    socket = new Socket(this.mHostName, this.mPort);
                }
                CIMClassCache.getInstance().clear(this.mHostName);
                HSCSubscriptionMgrImpl.println("created socket " + this.mPort);
                if (this.mPort != 9197) {
                    HSCSubscriptionMgrImpl.println("before create  HscRHSocket");
                    this.mSocket = new HscRHSocket(socket, false, this.mNameSpace);
                    HSCSubscriptionMgrImpl.println("after create  HscRHSocket");
                } else {
                    this.mSocket = new HSCSocket(socket, false);
                }
                this.mConnMonitor = new HSCCltConnMonitor(this);
                this.mConnMonitor.startMonitoring(this.mSocket);
                HSCSubscriptionMgrImpl.println("After start monitor");
                if (this.mLocalHostName == null) {
                    this.mLocalHostName = socket.getLocalAddress().getHostName();
                }
                return;
            }
            catch (Throwable throwable) {
                HSCSubscriptionMgrImpl.println(HSCSubscriptionMgrImpl.getStackTrace(throwable));
                this.logException(throwable);
                if (this.mRetry != -1 && System.currentTimeMillis() >= l) {
                    HSCSubscriptionMgrImpl.println("no retry after timeout " + this.mRetry);
                    this.mConnErrHandler.connectionError(this, throwable, this.mRetry);
                    break;
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public boolean reconnect() throws HSCException {
        if (this.mClosed || this.mInReconnect) {
            HSCSubscriptionMgrImpl.println("no reconnect, closed  " + this.mClosed + " mInReconnect " + this.mInReconnect);
            return false;
        }
        this.mInReconnect = true;
        try {
            try {
                HSCSubscriptionMgrImpl.println("generate lost conn event");
                this.handleEvent(this.createLostConnEvent());
            }
            catch (Throwable throwable) {
                HSCSubscriptionMgrImpl.println(HSCSubscriptionMgrImpl.getStackTrace(throwable));
            }
            if (this.mClosed) return false;
            try {
                HSCSubscriptionMgrImpl.println("closing conn mornitor");
                this.mConnMonitor.close();
            }
            catch (Throwable throwable) {
                HSCSubscriptionMgrImpl.println(HSCSubscriptionMgrImpl.getStackTrace(throwable));
            }
            if (!this.mReconnAfterFail) {
                HSCSubscriptionMgrImpl.println(" no reconnection after fail");
                this.mSocket = null;
                this.close();
                this.mInReconnect = false;
                boolean bl = false;
                this.mInReconnect = false;
                return bl;
            }
            HSCSubscriptionMgrImpl.println("reset authanticator");
            this.mAuthenticator.reset();
            this.mConnMonitor = null;
            this.connect();
            if (this.mSocket == null) {
                HSCSubscriptionMgrImpl.println("reconnecting failed");
                this.close();
                boolean bl = false;
                this.mInReconnect = false;
                return bl;
            }
            this.resubscribe();
            HSCSubscriptionMgrImpl.println("generate reconnect event");
            this.handleEvent(this.createReconnectEvent());
            boolean bl = true;
            this.mInReconnect = false;
            return bl;
        }
        finally {
            this.mInReconnect = false;
        }
    }

    public void resubscribe() throws Exception {
        Serializable serializable;
        Object k;
        Enumeration enumeration = this.mSubscriptions.keys();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (enumeration.hasMoreElements()) {
            k = enumeration.nextElement();
            serializable = (HSCCltSubscription)this.mSubscriptions.get(k);
            String string = ((HSCCltSubscription)serializable).getUserName() + " %%% " + ((HSCCltSubscription)serializable).getPassword();
            String string2 = (String)hashtable.get(string);
            if (string2 == null) {
                string2 = this.mAuthenticator.authenticate(((HSCCltSubscription)serializable).getUserName(), ((HSCCltSubscription)serializable).getPassword());
                if (string2 == null) {
                    this.unsubscribe(((HSCCltSubscription)serializable).getSubId(), ((HSCCltSubscription)serializable).getUserName(), ((HSCCltSubscription)serializable).getPassword());
                    continue;
                }
                hashtable.put(string, string2);
            }
            ((HSCCltSubscription)serializable).setAuthKey(string2);
        }
        enumeration = this.mEvents.keys();
        while (enumeration.hasMoreElements()) {
            k = enumeration.nextElement();
            serializable = (Vector)this.mEvents.get(k);
            this.subscribe((HSCCltSubscription)((Vector)serializable).elementAt(0));
        }
    }

    public void run() {
        try {
            while (!this.mClosed) {
                Object object = null;
                try {
                    if (this.mSocket == null && !this.reconnect()) break;
                    this.mInReading = true;
                    object = this.mSocket.readObject();
                    this.mInReading = false;
                    this.mLastCommTime = System.currentTimeMillis();
                }
                catch (Throwable throwable) {
                    this.mInReading = false;
                    HSCSubscriptionMgrImpl.println(HSCSubscriptionMgrImpl.getStackTrace(throwable));
                    if (this.reconnect()) continue;
                    break;
                }
                if (object == null) continue;
                if (!this.mClosed) {
                    if (!(object instanceof HSCEvent)) continue;
                    this.handleEvent((HSCEvent)object);
                    continue;
                }
                break;
            }
        }
        catch (HSCException hSCException) {
            HSCSubscriptionMgrImpl.println(HSCSubscriptionMgrImpl.getStackTrace(hSCException));
            this.logException(hSCException);
            throw new RuntimeException(hSCException.getMessage());
        }
    }

    public void closeSocket() {
        if (this.mSocket == null) {
            HSCSubscriptionMgrImpl.println("socket is null, cannot close");
            return;
        }
        try {
            HSCSocket hSCSocket = this.mSocket;
            this.mSocket = null;
            hSCSocket.close();
            if (this.mInReading) {
                this.interrupt();
                if (this.isInterrupted()) {
                    this.interrupted();
                }
            }
        }
        catch (Throwable throwable) {
            HSCSubscriptionMgrImpl.println(HSCSubscriptionMgrImpl.getStackTrace(throwable));
            this.logException(throwable);
        }
    }

    private void handleEvent(HSCEvent hSCEvent) {
        hSCEvent.setServerHostName(this.mHostName);
        String string = hSCEvent.getEventKey();
        HSCSubscriptionMgrImpl.println("Received ind evt " + string);
        Vector vector = (Vector)this.mEvents.get(string);
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                HSCCltSubscription hSCCltSubscription = (HSCCltSubscription)vector.elementAt(i);
                hSCEvent.setUserPass(hSCCltSubscription.getUserName(), hSCCltSubscription.getPassword());
                hSCCltSubscription.handleEvent(hSCEvent, this);
            }
        }
    }

    public int subscribe(int n, String string, String string2, String string3, HSCEventHandler hSCEventHandler) throws HSCException {
        HSCSubscriptionMgrImpl.println("handler before authanticate, objType " + string + " evtType " + n);
        String string4 = this.authenticate(string2, string3);
        HSCSubscriptionMgrImpl.println("handler after authanticate: " + string4);
        if (string4 == null) {
            return -1;
        }
        HSCHandlerSubscription hSCHandlerSubscription = new HSCHandlerSubscription(n, string, true, string2, string3, hSCEventHandler);
        hSCHandlerSubscription.setAuthKey(string4);
        this.subscribe(hSCHandlerSubscription);
        return hSCHandlerSubscription.getSubId();
    }

    public int subscribe(int n, String string, String string2, String string3, HSCCltEventQueue hSCCltEventQueue) throws HSCException {
        HSCSubscriptionMgrImpl.println("queue before authanticate, objType " + string + " evtType " + n);
        String string4 = this.authenticate(string2, string3);
        HSCSubscriptionMgrImpl.println("queue after authanticate: " + string4);
        if (string4 == null) {
            return -1;
        }
        HSCQueueSubscription hSCQueueSubscription = new HSCQueueSubscription(n, string, true, string2, string3, hSCCltEventQueue);
        hSCQueueSubscription.setAuthKey(string4);
        this.subscribe(hSCQueueSubscription);
        return hSCQueueSubscription.getSubId();
    }

    protected String authenticate(String string, String string2) throws HSCException {
        if (this.mClosed) {
            return null;
        }
        String string3 = this.needAuthenticate(string, string2);
        if (string3 == null && (string3 = this.mAuthenticator.authenticate(string, string2)) == null) {
            return null;
        }
        return string3;
    }

    private boolean subscribe(HSCCltSubscription hSCCltSubscription) throws HSCException {
        if (hSCCltSubscription.getSubId() == -1) {
            hSCCltSubscription.setSubId(HSCSubscriptionMgrImpl.getNextId());
            Integer n = new Integer(hSCCltSubscription.getSubId());
            this.mSubscriptions.put(n, hSCCltSubscription);
            String string = hSCCltSubscription.getEventKey();
            Vector<HSCCltSubscription> vector = (Vector<HSCCltSubscription>)this.mEvents.get(string);
            if (vector == null) {
                vector = new Vector<HSCCltSubscription>();
                this.mEvents.put(string, vector);
            }
            vector.addElement(hSCCltSubscription);
            if (vector.size() > 1) {
                return true;
            }
        }
        try {
            if (hSCCltSubscription.getEventType() != -1 && hSCCltSubscription.getEventType() != -2) {
                this.mSocket.writeObject(hSCCltSubscription.getServerSub(this.mPort));
                this.mLastCommTime = System.currentTimeMillis();
            }
        }
        catch (Throwable throwable) {
            HSCSubscriptionMgrImpl.println(HSCSubscriptionMgrImpl.getStackTrace(throwable));
            if (!this.mInReconnect) {
                this.reconnect();
            }
            throw new RuntimeException("subscribe failed");
        }
        return true;
    }

    public void unsubscribe(int n, String string, String string2) throws HSCException {
        if (this.mClosed) {
            return;
        }
        Integer n2 = new Integer(n);
        HSCCltSubscription hSCCltSubscription = (HSCCltSubscription)this.mSubscriptions.get(n2);
        if (hSCCltSubscription == null) {
            throw new HSCException(HSCResourceBundleUtil.getMessage(COMMON_BUNDLE_NAME, "ERROR_INVALID_SUB_ID", ERROR_INVALID_SUB_ID, new String[]{"" + n}));
        }
        if (!string.equals(hSCCltSubscription.getUserName()) || !string2.equals(hSCCltSubscription.getPassword())) {
            throw new HSCException(ERROR_AUTHENTICATE);
        }
        this.mSubscriptions.remove(n2);
        String string3 = hSCCltSubscription.getEventKey();
        Vector vector = (Vector)this.mEvents.get(string3);
        vector.removeElement(hSCCltSubscription);
        if (vector.size() == 0) {
            this.mEvents.remove(string3);
            hSCCltSubscription.setSubscription(false);
            try {
                if (hSCCltSubscription.getEventType() != -1 && hSCCltSubscription.getEventType() != -2) {
                    this.mSocket.writeObject(hSCCltSubscription.getServerSub(this.mPort));
                    this.mLastCommTime = System.currentTimeMillis();
                }
            }
            catch (IOException iOException) {
                HSCSubscriptionMgrImpl.println(HSCSubscriptionMgrImpl.getStackTrace(iOException));
                this.logException(iOException);
            }
        }
        if (this.mEvents.size() == 0 && this.mAutoClose) {
            this.close();
        }
    }

    public void unsubscribe(int n, String string, HSCEventHandler hSCEventHandler, String string2, String string3) throws HSCException {
        if (this.mClosed) {
            return;
        }
        Enumeration enumeration = this.mSubscriptions.keys();
        while (enumeration.hasMoreElements()) {
            HSCHandlerSubscription hSCHandlerSubscription;
            Object k = enumeration.nextElement();
            Object v = this.mSubscriptions.get(k);
            if (!(v instanceof HSCHandlerSubscription) || (hSCHandlerSubscription = (HSCHandlerSubscription)v).getEventType() != n || hSCHandlerSubscription.getObjectType() != null && !hSCHandlerSubscription.getObjectType().equals(string) || hSCHandlerSubscription.getHandler() != hSCEventHandler) continue;
            this.unsubscribe((Integer)k, string2, string3);
        }
    }

    public void unsubscribe(int n, String string, HSCCltEventQueue hSCCltEventQueue, String string2, String string3) throws HSCException {
        if (this.mClosed) {
            return;
        }
        Enumeration enumeration = this.mSubscriptions.keys();
        while (enumeration.hasMoreElements()) {
            HSCQueueSubscription hSCQueueSubscription;
            Object k = enumeration.nextElement();
            Object v = this.mSubscriptions.get(k);
            if (!(v instanceof HSCQueueSubscription) || (hSCQueueSubscription = (HSCQueueSubscription)v).getEventType() != n || hSCQueueSubscription.getObjectType() != null && !hSCQueueSubscription.getObjectType().equals(string) || hSCQueueSubscription.getQueue() != hSCCltEventQueue) continue;
            this.unsubscribe((Integer)k, string2, string3);
        }
    }

    public void close() throws HSCException {
        if (this.mClosed) {
            System.out.println("already closed");
            return;
        }
        this.mClosed = true;
        HSCSubscriptionMgrImpl.println("close subscription mgr");
        HSCSubscriptionMgrImpl.println(HSCSubscriptionMgrImpl.getStackTrace(new Exception()));
        this.mEvents = null;
        this.mSubscriptions = null;
        this.mAuthenticator = null;
        try {
            if (this.mSocket != null) {
                this.mSocket.close();
                this.mSocket = null;
            }
        }
        catch (Exception exception) {
            HSCSubscriptionMgrImpl.println(HSCSubscriptionMgrImpl.getStackTrace(exception));
            this.logException(exception);
            throw new HSCException("Close subscription failed", exception);
        }
        try {
            if (this.mConnMonitor != null) {
                this.mConnMonitor.close();
            }
        }
        catch (Exception exception) {
            HSCSubscriptionMgrImpl.println(HSCSubscriptionMgrImpl.getStackTrace(exception));
            this.logException(exception);
            throw new HSCException("Close connection monitor failed", exception);
        }
    }

    private String needAuthenticate(String string, String string2) {
        Enumeration enumeration = this.mSubscriptions.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            HSCCltSubscription hSCCltSubscription = (HSCCltSubscription)this.mSubscriptions.get(k);
            if (!hSCCltSubscription.getUserName().equals(string) || !hSCCltSubscription.getPassword().equals(string2)) continue;
            return hSCCltSubscription.getAuthKey();
        }
        return null;
    }

    public HSCEvent createLostConnEvent() {
        return new HSCEvent(-1, null, null, null, System.currentTimeMillis());
    }

    public HSCEvent createReconnectEvent() {
        return new HSCEvent(-2, null, null, null, System.currentTimeMillis());
    }

    public void logException(Throwable throwable) {
        if (this.mErrLogger != null) {
            this.mErrLogger.logException(throwable);
        }
    }

    public String getNameSpace() {
        return this.mNameSpace;
    }

    static {
        try {
            mLogFileName = System.getProperty("HMCIndicationClientLogFileName");
            if (mLogFileName != null) {
                FileOutputStream fileOutputStream = new FileOutputStream(mLogFileName);
                mLogPrintStream = new PrintStream(fileOutputStream);
            } else {
                File file = new File("/tmp/wsmdebug");
                mLogPrintStream = file.exists() ? System.err : null;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            mLogPrintStream = null;
        }
    }
}

